﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ZSMusic.Model
{
    [Serializable]
    public class ErrReport
    {
        public string Id { get; set; }
        public string ClassName { get; set; }
        public string Message { get; set; }
        public DateTime Time { get; set; }
        public Exception Detail { get; set; }
        public ErrReport()
        { }
        public ErrReport(Exception ex)
        {
            Id = ex.GetHashCode().ToString();
            ClassName = ex.GetType().ToString();
            Message = ex.Message;
            Time = DateTime.Now;
            Detail = ex;
        }
        public override string ToString()
        {
            return string.Format("{0} {1}",ClassName,Message);
        }
        //create table ErrReport
        //(
        //Id varchar(128) primary key,
        //ClassName varchar(128)not null,
        //[Message] varchar(128),
        //[Time] datetime not null,
        //Detail varchar(max)
        //)
    }
}